"""Tests for parsing Slurm's node string"""

import unittest
from engine.schedulers.schedulers import slurm_node_parser

class TestSlurmNodeParsing(unittest.TestCase):

    def test_single_node(self):
        assert slurm_node_parser("n1262") == ["n1262"]
        assert slurm_node_parser("nautilus-mla03") == ["nautilus-mla03"]
        assert slurm_node_parser("dart12") == ["dart12"]
        assert slurm_node_parser("reefgpu03") == ["reefgpu03"]

    def test_reef_multi_node(self):
        assert slurm_node_parser("reefnode[01-03,05,07-09]") == [
            "reefnode01",
            "reefnode02",
            "reefnode03",
            "reefnode05",
            "reefnode07",
            "reefnode08",
            "reefnode09"
        ]

    def test_jean_multi_node(self):
        assert slurm_node_parser("jean[110-113,169-171,433-438]") == [
            "jean110",
            "jean111",
            "jean112",
            "jean113",
            "jean169",
            "jean170",
            "jean171",
            "jean433",
            "jean434",
            "jean435",
            "jean436",
            "jean437",
            "jean438",
        ]

    def test_nautilus_multi_node(self):
        assert slurm_node_parser("n[0020,0023-0024,0028,0473-0477,0896,0999-1002,1105-1106]") == [
            "n0020",
            "n0023",
            "n0024",
            "n0028",
            "n0473",
            "n0474",
            "n0475",
            "n0476",
            "n0477",
            "n0896",
            "n0999",
            "n1000",
            "n1001",
            "n1002",
            "n1105",
            "n1106"
        ]
